
markup.push({

	// MARK: Compressor

	SimpleCompressorBlock:
	{
		"+": "BlockTemplate",
		gxTitle: "Simple Compressor",
		gxAllowTallTitle: true,
		geNodeClass: "AHCompressorNode",
		gxPopoverInfo: "SimpleCompressorPopover",
		gxLibraryDescription: "Reduce range between soft and loud sounds",
		gxLibraryIcon: "library.compressor",
		gxChildViews:
		{
			label: {
				"+": "LabelView.foreColorTheme1.size11",
				gxFrameRect: "18,48,83,25",
				gxDefaultValue: "Mode"
			},
			presetName: {
				"+": "BlockPopup",
				gxValueKey: "node.preset",
				gxFrameRect: "16,69,88,18",
				gxForePainter: {
					"+": "BlockPopupFore",
					gxEdgeInsets: "0, 0, 0, 0",
				},
				gxMenuItemsKeyPath: "node.presetMenuItems",
				axTitle: "Compressor Mode",
				axIsIgnored: false,
			},
		}
	},
	
	// MARK: popover

	SimpleCompressorPopover:
	{
		"+": "PopoverTemplate",
		gxTitle: "Simple Compressor",
		gxCanDrawSubviewsIntoLayer: true,
		gxLayout: [ "H:|-12-[self(320)]-12-|",	// sets popover width
					"V:|-12-[self]-12-|",
					"V:|-41-[group]-16-|"
		],
		gxChildViews:
		{
			title: "PopoverTitle",
			switch: "PopoverOnOffSwitch",
			group: {
				"+": "GroupView.noBottomStroke",
				gxLayout: [
					"H:|-0-[self]-0-|",
						   
					"V:|-16-[mode]-10-[text(31)]-0-|",
					"V:[mode]-11-[infoIcon]",

					"H:|-14-[modeLabel]-8-[mode]-14-|&alignBaseline",

					"H:|-14-[infoIcon(16)]-8-[text]-11-|",
				],
				gxChildViews: {
					modeLabel: labelView("Compressor Mode:"),
					mode: {
						"+": "PopupMenuTemplate",
						gxValueKey: "node.preset",
						gxMenuItemsKeyPath: "node.presetMenuItems",
						axIsIgnored: false,
						axTitle: "Compressor Mode",
					},
					infoIcon: { "+": "InfoIcon" },
					text: {
						"+": "DescriptionLabelView",
						gxDefaultValue: "Reduce the volume of loud audio and boost quieter passages.",
					},
				}
			}
		}
	},


})
